import os
import sys

ROOT_PATH = os.path.dirname(__file__)
TASK_LIST = ("VCUHARM", "VRCHARM", "VRAHARM", "VCTHARM", "VFCHARM", "VKCUHARM")

if sys.platform.lower() in ["darwin"]:  # OSX
    CC_APP = "/Applications/Toon Boom Harmony 16.0 Premium Network/Controlcenter.app/Contents/MacOS/Controlcenter"
    DBU_APP = "/Applications/Toon Boom Harmony 16.0 Premium Network/tba/macosx/bin/dbu"
    BASE_JOB_DIR = "//USA_DB/db_jobs"
    DB_PATH = "//USA_DB/online_jobs/jobs.db"
elif sys.platform.lower() in ["win32", "cygwin"]:  # Windows
    CC_APP = "C:/Program Files (x86)/Toon Boom Animation/Toon Boom Harmony 16.0 Premium/win64/bin/Controlcenter.exe"
    DBU_APP = "C:/Program Files (x86)/Toon Boom Animation/Toon Boom Harmony 16.0 Premium/win64/bin/dbu.exe"
    BASE_JOB_DIR = "//harmony/USA_DB/db_jobs"
    DB_PATH = "//harmony/USA_DB/online_jobs/jobs.db"
elif sys.platform.lower() in ["linux2"]:  # Linux
    CC_APP = "//harmony/usr/local/ToonBoomAnimation/harmonyPremium_16.0/lnx86_64/bin/Controlcenter"
    DBU_APP = "//harmony/usr/local/ToonBoomAnimation/harmonyPremium_16.0/lnx86_64/bin/dbu"
    BASE_JOB_DIR = "//USA_DB/db_jobs"
    DB_PATH = "//USA_DB/online_jobs/jobs.db"
